/*
 * Decompiled with CFR 0.152.
 */
package panther.util.resource;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import panther.util.general.OpsOut;
import panther.util.resource.ConnectionWrapper;
import panther.util.resource.DbParameter;
import panther.util.resource.ResultSetWrapper;
import panther.util.resource.StatementWrapper;

public class PreparedStatementWrapper
extends StatementWrapper
implements PreparedStatement {
    public static final int BLANK = 0;
    public static final int SET_NULL01 = 1;
    public static final int SET_BOOLEAN = 2;
    public static final int SET_BYTE = 3;
    public static final int SET_SHORT = 4;
    public static final int SET_INT = 5;
    public static final int SET_LONG = 6;
    public static final int SET_FLOAT = 7;
    public static final int SET_DOUBLE = 8;
    public static final int SET_BIGDECIMAL = 9;
    public static final int SET_STRING = 10;
    public static final int SET_BYTES = 11;
    public static final int SET_DATE01 = 12;
    public static final int SET_TIME = 13;
    public static final int SET_TIMESTAMP01 = 14;
    public static final int SET_ASCIISTREAM = 15;
    public static final int SET_UNICODESTREAM = 16;
    public static final int SET_BINARYSTREAM = 17;
    public static final int SET_OBJECT01 = 18;
    public static final int SET_OBJECT02 = 19;
    public static final int SET_CHARACTERSTREAM = 20;
    public static final int SET_REF = 21;
    public static final int SET_BLOB = 22;
    public static final int SET_CLOB = 23;
    public static final int SET_ARRAY = 24;
    public static final int SET_DATE02 = 25;
    public static final int SET_TIMESTAMP02 = 26;
    public static final int SET_NULL02 = 27;
    public static final int SET_OBJECT03 = 28;
    public static final int SET_TIME02 = 29;
    protected ArrayList inParameters = new ArrayList();
    protected String sql;
    public static final String notImplemented = "This method is not implemented in the CachedResultSet";

    public PreparedStatementWrapper(PreparedStatement preparedStatement, ConnectionWrapper connectionWrapper, String string) {
        super(preparedStatement, connectionWrapper);
        this.sql = string;
    }

    public void rebuildStatement() {
        try {
            this.stmt = this.sql == null ? this.conn.recreateStatement() : this.conn.recreatePrepared(this.sql);
        }
        catch (SQLException sQLException) {
            OpsOut.println("Unable to rebuild the statement. :(");
            OpsOut.trace(sQLException);
        }
    }

    public void rebuildInParameters() {
        int n = 0;
        n = this.inParameters.size();
        try {
            block33: for (int i = 0; i < n; ++i) {
                DbParameter dbParameter = (DbParameter)this.inParameters.get(i);
                switch (dbParameter.getFunction()) {
                    case 1: {
                        this.setNull(dbParameter.getIndex(), (Integer)dbParameter.getObject());
                        continue block33;
                    }
                    case 2: {
                        this.setBoolean(dbParameter.getIndex(), (Boolean)dbParameter.getObject());
                        continue block33;
                    }
                    case 3: {
                        this.setByte(dbParameter.getIndex(), (Byte)dbParameter.getObject());
                        continue block33;
                    }
                    case 4: {
                        this.setShort(dbParameter.getIndex(), (Short)dbParameter.getObject());
                        continue block33;
                    }
                    case 5: {
                        this.setInt(dbParameter.getIndex(), (Integer)dbParameter.getObject());
                        continue block33;
                    }
                    case 6: {
                        this.setLong(dbParameter.getIndex(), (Long)dbParameter.getObject());
                        continue block33;
                    }
                    case 7: {
                        this.setFloat(dbParameter.getIndex(), ((Float)dbParameter.getObject()).floatValue());
                        continue block33;
                    }
                    case 8: {
                        this.setDouble(dbParameter.getIndex(), (Double)dbParameter.getObject());
                        continue block33;
                    }
                    case 9: {
                        this.setBigDecimal(dbParameter.getIndex(), (BigDecimal)dbParameter.getObject());
                        continue block33;
                    }
                    case 10: {
                        this.setString(dbParameter.getIndex(), (String)dbParameter.getObject());
                        continue block33;
                    }
                    case 11: {
                        this.setBytes(dbParameter.getIndex(), (byte[])dbParameter.getObject());
                        continue block33;
                    }
                    case 12: {
                        this.setDate(dbParameter.getIndex(), (Date)dbParameter.getObject());
                        continue block33;
                    }
                    case 13: {
                        this.setTime(dbParameter.getIndex(), (Time)dbParameter.getObject());
                        continue block33;
                    }
                    case 14: {
                        this.setTimestamp(dbParameter.getIndex(), (Timestamp)dbParameter.getObject());
                        continue block33;
                    }
                    case 15: {
                        this.setAsciiStream(dbParameter.getIndex(), (InputStream)dbParameter.getObject(), dbParameter.getLength());
                        continue block33;
                    }
                    case 16: {
                        this.setUnicodeStream(dbParameter.getIndex(), (InputStream)dbParameter.getObject(), dbParameter.getLength());
                        continue block33;
                    }
                    case 17: {
                        this.setBinaryStream(dbParameter.getIndex(), (InputStream)dbParameter.getObject(), dbParameter.getLength());
                        continue block33;
                    }
                    case 18: {
                        this.setObject(dbParameter.getIndex(), dbParameter.getObject(), dbParameter.getTargetSqlType(), dbParameter.getLength());
                        continue block33;
                    }
                    case 19: {
                        this.setObject(dbParameter.getIndex(), dbParameter.getObject(), dbParameter.getTargetSqlType());
                        continue block33;
                    }
                    case 28: {
                        this.setObject(dbParameter.getIndex(), dbParameter.getObject());
                        continue block33;
                    }
                    case 20: {
                        this.setCharacterStream(dbParameter.getIndex(), (Reader)dbParameter.getObject(), dbParameter.getLength());
                        continue block33;
                    }
                    case 21: {
                        this.setRef(dbParameter.getIndex(), (Ref)dbParameter.getObject());
                        continue block33;
                    }
                    case 22: {
                        this.setBlob(dbParameter.getIndex(), (Blob)dbParameter.getObject());
                        continue block33;
                    }
                    case 23: {
                        this.setClob(dbParameter.getIndex(), (Clob)dbParameter.getObject());
                        continue block33;
                    }
                    case 24: {
                        this.setArray(dbParameter.getIndex(), (Array)dbParameter.getObject());
                        continue block33;
                    }
                    case 25: {
                        this.setDate(dbParameter.getIndex(), (Date)dbParameter.getObject(), dbParameter.getCalendar());
                        continue block33;
                    }
                    case 26: {
                        this.setTime(dbParameter.getIndex(), (Time)dbParameter.getObject(), dbParameter.getCalendar());
                        continue block33;
                    }
                    case 27: {
                        this.setNull(dbParameter.getIndex(), (Integer)dbParameter.getObject(), dbParameter.getTypeName());
                        continue block33;
                    }
                    case 29: {
                        this.setTime(dbParameter.getIndex(), (Time)dbParameter.getObject(), dbParameter.getCalendar());
                    }
                }
            }
        }
        catch (Exception exception) {
            OpsOut.println("Problems encountered when recreating in params.");
            OpsOut.trace(exception);
        }
    }

    private String getOracleSqlString() {
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        DbParameter dbParameter = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer = stringBuffer.append("Oracle SQL syntax:\n");
        n3 = this.sql.indexOf("?", n2);
        while (n3 > 0 && this.validParameter(n3)) {
            dbParameter = this.atInParameter(n);
            if (dbParameter == null) {
                OpsOut.println("ERROR: No parameter with index " + n + " found!");
            } else {
                stringBuffer.append(this.sql.substring(n2, n3));
                stringBuffer.append(this.getInParameterValue(dbParameter));
                ++n;
            }
            n4 = n3;
            n2 = n3 + 1;
            n3 = this.sql.indexOf("?", n2);
        }
        stringBuffer.append(this.sql.substring(n4 + 1, this.sql.length()));
        return stringBuffer.toString();
    }

    public boolean validParameter(int n) {
        int n2 = 0;
        int n3 = 0;
        String string = this.sql.substring(0, n);
        n2 = string.indexOf("'", n2);
        while (n2 > 0) {
            ++n3;
            n2 = string.indexOf("'", n2);
        }
        return n3 % 2 == 0;
    }

    public DbParameter atInParameter(int n) {
        for (int i = 0; i < this.inParameters.size(); ++i) {
            DbParameter dbParameter = (DbParameter)this.inParameters.get(i);
            if (dbParameter.getIndex() != n) continue;
            return dbParameter;
        }
        return null;
    }

    public String getInParameterValue(DbParameter dbParameter) {
        int n = dbParameter.getFunction();
        if (dbParameter.getObject() == null) {
            return "<NULL VALUE>";
        }
        if (n == 5 || n == 6 || n == 7 || n == 8 || n == 9) {
            return dbParameter.getObject().toString();
        }
        if (n == 1) {
            return "null";
        }
        if (n == 2) {
            return dbParameter.getObject().toString();
        }
        if (n == 3) {
            return dbParameter.getObject().toString();
        }
        if (n == 10) {
            return "'" + dbParameter.getObject().toString() + "'";
        }
        if (n == 11) {
            return dbParameter.getObject().toString();
        }
        if (n == 12) {
            return "TO_DATE('" + ((Date)dbParameter.getObject()).toString() + "', 'yyyy-mm-dd')";
        }
        if (n == 25) {
            return "TO_DATE('" + ((Date)dbParameter.getObject()).toString() + "', 'yyyy-mm-dd')";
        }
        if (n == 13) {
            return "'" + ((Time)dbParameter.getObject()).toString() + "'";
        }
        if (n == 29) {
            return "'" + ((Time)dbParameter.getObject()).toString() + "'";
        }
        if (n == 14) {
            return "TO_DATE('" + ((Timestamp)dbParameter.getObject()).toString() + "', 'yyyy-mm-dd hh:mm:ss')";
        }
        if (n == 26) {
            return "TO_DATE('" + ((Timestamp)dbParameter.getObject()).toString() + "', 'yyyy-mm-dd hh:mm:ss')";
        }
        if (n == 15) {
            return "<ASCII stream>";
        }
        if (n == 16) {
            return "<Unicode stream>";
        }
        if (n == 17) {
            return "<Binary stream>";
        }
        if (n == 18) {
            return "<Object>";
        }
        if (n == 19) {
            return "<Object>";
        }
        if (n == 28) {
            return "<Object>";
        }
        if (n == 20) {
            return "<Character Stream>";
        }
        if (n == 21) {
            return "<Ref>";
        }
        if (n == 22) {
            return "<BLOB>";
        }
        if (n == 23) {
            return "<CLOB>";
        }
        if (n == 24) {
            return "<ARRAY>";
        }
        if (n == 27) {
            return "null";
        }
        return "<ERROR>";
    }

    public ResultSet executeQuery() throws SQLException {
        ResultSetWrapper resultSetWrapper = new ResultSetWrapper(((PreparedStatement)this.stmt).executeQuery(), this);
        this.inParameters.clear();
        this.resultSets.add(resultSetWrapper);
        return resultSetWrapper;
    }

    public int executeUpdate() throws SQLException {
        this.inParameters.clear();
        return ((PreparedStatement)this.stmt).executeUpdate();
    }

    public void setNull(int n, int n2) throws SQLException {
        this.inParameters.add(new DbParameter(n, new Integer(n2), 0, 0, 1, null, null));
        ((PreparedStatement)this.stmt).setNull(n, n2);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.inParameters.add(new DbParameter(n, new Boolean(bl), 0, 0, 2, null, null));
        ((PreparedStatement)this.stmt).setBoolean(n, bl);
    }

    public void setByte(int n, byte by) throws SQLException {
        this.inParameters.add(new DbParameter(n, new Byte(by), 0, 0, 3, null, null));
        ((PreparedStatement)this.stmt).setByte(n, by);
    }

    public void setShort(int n, short s) throws SQLException {
        this.inParameters.add(new DbParameter(n, new Short(s), 0, 0, 4, null, null));
        ((PreparedStatement)this.stmt).setShort(n, s);
    }

    public void setInt(int n, int n2) throws SQLException {
        this.inParameters.add(new DbParameter(n, new Integer(n2), 0, 0, 5, null, null));
        ((PreparedStatement)this.stmt).setInt(n, n2);
    }

    public void setLong(int n, long l) throws SQLException {
        this.inParameters.add(new DbParameter(n, new Long(l), 0, 0, 6, null, null));
        ((PreparedStatement)this.stmt).setLong(n, l);
    }

    public void setFloat(int n, float f) throws SQLException {
        this.inParameters.add(new DbParameter(n, new Float(f), 0, 0, 7, null, null));
        ((PreparedStatement)this.stmt).setFloat(n, f);
    }

    public void setDouble(int n, double d) throws SQLException {
        this.inParameters.add(new DbParameter(n, new Double(d), 0, 0, 8, null, null));
        ((PreparedStatement)this.stmt).setDouble(n, d);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.inParameters.add(new DbParameter(n, bigDecimal, 0, 0, 9, null, null));
        ((PreparedStatement)this.stmt).setBigDecimal(n, bigDecimal);
    }

    public void setString(int n, String string) throws SQLException {
        this.inParameters.add(new DbParameter(n, string, 0, 0, 10, null, null));
        ((PreparedStatement)this.stmt).setString(n, string);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.inParameters.add(new DbParameter(n, byArray, 0, 0, 11, null, null));
        ((PreparedStatement)this.stmt).setBytes(n, byArray);
    }

    public void setDate(int n, Date date) throws SQLException {
        this.inParameters.add(new DbParameter(n, date, 0, 0, 12, null, null));
        ((PreparedStatement)this.stmt).setDate(n, date);
    }

    public void setTime(int n, Time time) throws SQLException {
        this.inParameters.add(new DbParameter(n, time, 0, 0, 13, null, null));
        ((PreparedStatement)this.stmt).setTime(n, time);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.inParameters.add(new DbParameter(n, timestamp, 0, 0, 14, null, null));
        ((PreparedStatement)this.stmt).setTimestamp(n, timestamp);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.inParameters.add(new DbParameter(n, inputStream, n2, 0, 15, null, null));
        ((PreparedStatement)this.stmt).setAsciiStream(n, inputStream, n2);
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.inParameters.add(new DbParameter(n, inputStream, n2, 0, 16, null, null));
        ((PreparedStatement)this.stmt).setUnicodeStream(n, inputStream, n2);
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.inParameters.add(new DbParameter(n, inputStream, n2, 0, 17, null, null));
        ((PreparedStatement)this.stmt).setBinaryStream(n, inputStream, n2);
    }

    public void clearParameters() throws SQLException {
        this.inParameters.clear();
        ((PreparedStatement)this.stmt).clearParameters();
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.inParameters.add(new DbParameter(n, object, n3, n2, 18, null, null));
        ((PreparedStatement)this.stmt).setObject(n, object, n2, n3);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.inParameters.add(new DbParameter(n, object, 0, n2, 19, null, null));
        ((PreparedStatement)this.stmt).setObject(n, object, n2);
    }

    public void setObject(int n, Object object) throws SQLException {
        this.inParameters.add(new DbParameter(n, object, 0, 0, 28, null, null));
        ((PreparedStatement)this.stmt).setObject(n, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws SQLException {
        int n = 0;
        try {
            boolean bl = ((PreparedStatement)this.stmt).execute();
            return bl;
        }
        catch (SQLException sQLException) {
            n = sQLException.getErrorCode();
            OpsOut.println("SQL Error code: " + n);
            if (n == 4068) {
                this.conn.resetConnection();
                this.rebuildStatement();
                this.rebuildInParameters();
                boolean bl = ((PreparedStatement)this.stmt).execute();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.inParameters.clear();
        }
    }

    public void addBatch() throws SQLException {
        ((PreparedStatement)this.stmt).addBatch();
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.inParameters.add(new DbParameter(n, reader, n2, 0, 20, null, null));
        ((PreparedStatement)this.stmt).setCharacterStream(n, reader, n2);
    }

    public void setRef(int n, Ref ref) throws SQLException {
        this.inParameters.add(new DbParameter(n, ref, 0, 0, 21, null, null));
        ((PreparedStatement)this.stmt).setRef(n, ref);
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        this.inParameters.add(new DbParameter(n, blob, 0, 0, 22, null, null));
        ((PreparedStatement)this.stmt).setBlob(n, blob);
    }

    public void setClob(int n, Clob clob) throws SQLException {
        this.inParameters.add(new DbParameter(n, clob, 0, 0, 23, null, null));
        ((PreparedStatement)this.stmt).setClob(n, clob);
    }

    public void setArray(int n, Array array) throws SQLException {
        this.inParameters.add(new DbParameter(n, array, 0, 0, 24, null, null));
        ((PreparedStatement)this.stmt).setArray(n, array);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return ((PreparedStatement)this.stmt).getMetaData();
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.inParameters.add(new DbParameter(n, date, 0, 0, 25, calendar, null));
        ((PreparedStatement)this.stmt).setDate(n, date, calendar);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.inParameters.add(new DbParameter(n, time, 0, 0, 29, calendar, null));
        ((PreparedStatement)this.stmt).setTime(n, time, calendar);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.inParameters.add(new DbParameter(n, timestamp, 0, 0, 26, calendar, null));
        ((PreparedStatement)this.stmt).setTimestamp(n, timestamp, calendar);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.inParameters.add(new DbParameter(n, new Integer(n2), 0, 0, 27, null, string));
        ((PreparedStatement)this.stmt).setNull(n, n2, string);
    }

    public void setURL(int n, URL uRL) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }
}

